// Define a new frame type: this is going to be our main frame

#include "wx/imaglist.h"
#include "wx/notebook.h"
#include "wx/string.h"
#include "wx/list.h"
#include "wx/printdlg.h"
#include "wx/dialup.h"

extern BOLTUser *user;

class BOLTPage;

class BOLTFrame : public wxFrame
{
DECLARE_DYNAMIC_CLASS(BOLTFrame)
public:
	void OnCalculator(wxCommandEvent & event);
	wxButton * bClose;
	wxFont fixedFont;
	BOLTFrame();
	wxString LicenseContact;
	RECORD_ID licenseId;
	bool IsValidLicense(wxString code);
	void LicenseViolation();
	void FreeLicense();
	wxString AquireLicense();
	bool inOnMenu;
	void OnMenu(wxCommandEvent & event);
	wxStaticText * tHeader;
	void OnHelp(wxCommandEvent & event);
	double QuickPay(RECORD_ID transactionId);
	virtual void OnChar(wxKeyEvent & event);
	void ReopenForm(int formID, RECORD_ID recordID);
	~BOLTFrame();
    // ctor(s)
    BOLTFrame(const wxString& title, const wxPoint& pos, const wxSize& size);

    // event handlers (these functions should _not_ be virtual)
    void OnQuit(wxCommandEvent& event);
    void OnLogout(wxCommandEvent& event);
    void OnAbout(wxCommandEvent& event);
	void OnButton(wxCommandEvent& event);
	void OnPageMenu(wxCommandEvent& event);
	void OnClosePage(wxCommandEvent& event);
	void OnChangePage(wxNotebookEvent& event);
	virtual bool Close(bool force=FALSE);
	BOLTPage *DispatchForm(int formId, RECORD_ID recordID);
	void RefreshForm(int formId, RECORD_ID recordID);
		bool closing;

	wxPrintDialogData pdData;
	wxPageSetupDialogData psData;
	wxPrintData pData;

	wxDialUpManager *dialUp;
	BOLTdb *db;
	wxNotebook *nbWin;
virtual void Dump(ostream& stream) 
	{	stream << "Dump : BOLTFrame"; }

private:
	void AddQuickPicks(int formID,BOLTChooser *bc);

	void UpdateMenus();

	wxImageList *nbImgs;
	wxMenu *pMenu;
	wxMenu *prgMenu;
	wxMenu *hMenu;
	wxArrayString *formList;
	// any class wishing to process wxWindows events must use this macro
    DECLARE_EVENT_TABLE()
};
